<?php $__env->startSection('title', __('report.stock_report')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo e(__('report.stock_report'), false); ?></h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>
              <?php echo Form::open(['url' => action([\App\Http\Controllers\ReportController::class, 'getStockReport']), 'method' => 'get', 'id' => 'stock_report_filter_form' ]); ?>

                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('location_id',  __('purchase.business_location') . ':'); ?>

                        <?php echo Form::select('location_id', $business_locations, null, ['class' => 'form-control select2', 'style' => 'width:100%']); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('category_id', __('category.category') . ':'); ?>

                        <?php echo Form::select('category', $categories, null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'category_id']); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('sub_category_id', __('product.sub_category') . ':'); ?>

                        <?php echo Form::select('sub_category', array(), null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'sub_category_id']); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('brand', __('product.brand') . ':'); ?>

                        <?php echo Form::select('brand', $brands, null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%']); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('unit',__('product.unit') . ':'); ?>

                        <?php echo Form::select('unit', $units, null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%']); ?>

                    </div>
                </div>
                <?php if($show_manufacturing_data): ?>
                    <div class="col-md-3">
                        <div class="form-group">
                            <br>
                            <div class="checkbox">
                                <label>
                                  <?php echo Form::checkbox('only_mfg', 1, false, 
                                  [ 'class' => 'input-icheck', 'id' => 'only_mfg_products']); ?> <?php echo e(__('manufacturing::lang.only_mfg_products'), false); ?>

                                </label>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php echo Form::close(); ?>

            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_product_stock_value')): ?>
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-solid']); ?>
            <table class="table no-border">
                <tr>
                    <td><?php echo app('translator')->get('report.closing_stock'); ?> (<?php echo app('translator')->get('lang_v1.by_purchase_price'); ?>)</td>
                    <td><?php echo app('translator')->get('report.closing_stock'); ?> (<?php echo app('translator')->get('lang_v1.by_sale_price'); ?>)</td>
                    <td><?php echo app('translator')->get('lang_v1.potential_profit'); ?></td>
                    <td><?php echo app('translator')->get('lang_v1.profit_margin'); ?></td>
                </tr>
                <tr>
                    <td><h3 id="closing_stock_by_pp" class="mb-0 mt-0"></h3></td>
                    <td><h3 id="closing_stock_by_sp" class="mb-0 mt-0"></h3></td>
                    <td><h3 id="potential_profit" class="mb-0 mt-0"></h3></td>
                    <td><h3 id="profit_margin" class="mb-0 mt-0"></h3></td>
                </tr>
            </table>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
    <?php endif; ?>
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-solid']); ?>
                <?php echo $__env->make('report.partials.stock_report_table', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="<?php echo e(asset('js/report.js?v=' . $asset_v), false); ?>"></script>
    
    
    <script>
            var stock_report_cols = [
            { data: 'sku', name: 'variations.sub_sku' },
            { data: 'product', name: 'p.name' },
            { data: 'variation', name: 'variation' },
            { data: 'category_name', name: 'c.name' },
            { data: 'location_name', name: 'l.name' },
            { data: 'unit_price', name: 'variations.sell_price_inc_tax' },
            { data: 'stock', name: 'stock', searchable: false },
        ];
 
        if ($('th.stock_price').length) {
            stock_report_cols.push({ data: 'stock_price', name: 'stock_price', searchable: false });
            stock_report_cols.push({ data: 'stock_value_by_sale_price', name: 'stock_value_by_sale_price', searchable: false, orderable: false });
            stock_report_cols.push({ data: 'potential_profit', name: 'potential_profit', searchable: false, orderable: false });
        }

        stock_report_cols.push({ data: 'total_sold', name: 'total_sold', searchable: false });
        stock_report_cols.push({ data: 'total_transfered', name: 'total_transfered', searchable: false });
        stock_report_cols.push({ data: 'total_adjusted', name: 'total_adjusted', searchable: false });
        stock_report_cols.push({ data: 'product_custom_field1', name: 'p.product_custom_field1'});
        stock_report_cols.push({ data: 'product_custom_field2', name: 'p.product_custom_field2'});
        stock_report_cols.push({ data: 'product_custom_field3', name: 'p.product_custom_field3'});
        stock_report_cols.push({ data: 'product_custom_field4', name: 'p.product_custom_field4'});

        if ($('th.current_stock_mfg').length) {
            stock_report_cols.push({ data: 'total_mfg_stock', name: 'total_mfg_stock', searchable: false });
        }
    //Stock report table
    stock_report_table = $('#stock_report_table').DataTable({
        processing: true,
        serverSide: true,
        scrollY: "75vh",
        scrollX:        true,
        scrollCollapse: true,
        ajax: {
            url: '/reports/stock-report',
            data: function(d) {
               
                d.location_id = $('#location_id').val();
                d.category_id = $('#category_id').val();
                d.sub_category_id = $('#sub_category_id').val();
                d.brand_id = $('#brand').val();
                d.unit_id = $('#unit').val();

                d.only_mfg_products = $('#only_mfg_products').length && $('#only_mfg_products').is(':checked') ? 1 : 0;
            },
        },
        columns: stock_report_cols,
        fnDrawCallback: function(oSettings) {
            __currency_convert_recursively($('#stock_report_table'));
        },
        "footerCallback": function ( row, data, start, end, display ) {
            var footer_total_stock = 0;
            var footer_total_sold = 0;
            var footer_total_transfered = 0;
            var total_adjusted = 0;
            var total_stock_price = 0;
            var footer_stock_value_by_sale_price = 0;
            var total_potential_profit = 0;
            var footer_total_mfg_stock = 0;
            for (var r in data){
                footer_total_stock += $(data[r].stock).data('orig-value') ? 
                parseFloat($(data[r].stock).data('orig-value')) : 0;

                footer_total_sold += $(data[r].total_sold).data('orig-value') ? 
                parseFloat($(data[r].total_sold).data('orig-value')) : 0;

                footer_total_transfered += $(data[r].total_transfered).data('orig-value') ? 
                parseFloat($(data[r].total_transfered).data('orig-value')) : 0;

                total_adjusted += $(data[r].total_adjusted).data('orig-value') ? 
                parseFloat($(data[r].total_adjusted).data('orig-value')) : 0;

                total_stock_price += $(data[r].stock_price).data('orig-value') ? 
                parseFloat($(data[r].stock_price).data('orig-value')) : 0;

                footer_stock_value_by_sale_price += $(data[r].stock_value_by_sale_price).data('orig-value') ? 
                parseFloat($(data[r].stock_value_by_sale_price).data('orig-value')) : 0;

                total_potential_profit += $(data[r].potential_profit).data('orig-value') ? 
                parseFloat($(data[r].potential_profit).data('orig-value')) : 0;

                footer_total_mfg_stock += $(data[r].total_mfg_stock).data('orig-value') ? 
                parseFloat($(data[r].total_mfg_stock).data('orig-value')) : 0;
            }

            $('.footer_total_stock').html(__currency_trans_from_en(footer_total_stock, false));
            $('.footer_total_stock_price').html(__currency_trans_from_en(total_stock_price));
            $('.footer_total_sold').html(__currency_trans_from_en(footer_total_sold, false));
            $('.footer_total_transfered').html(__currency_trans_from_en(footer_total_transfered, false));
            $('.footer_total_adjusted').html(__currency_trans_from_en(total_adjusted, false));
            $('.footer_stock_value_by_sale_price').html(__currency_trans_from_en(footer_stock_value_by_sale_price));
            $('.footer_potential_profit').html(__currency_trans_from_en(total_potential_profit));
            if ($('th.current_stock_mfg').length) {
                $('.footer_total_mfg_stock').html(__currency_trans_from_en(footer_total_mfg_stock, false));
            }
        },
    });

    </script>
    
    
    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rragroso/pos.rragrosolutions.com/resources/views/report/stock_report.blade.php ENDPATH**/ ?>